/**
 *
 */

#ifndef __meeting_service_object_manager_h__
#define __meeting_service_object_manager_h__

namespace CSFUnified
{
	class MeetingMgrControllerImpl;
	class DesktopSharingControllerImpl;
	class MeetingAccountControllerImpl;
	class CMRControllerMgr;
	class JabberServiceProvider;
	class JabberServiceSink;

    class MeetingServiceObjectManager
    {
    public:
        static MeetingServiceObjectManager& getInstance()
        {
            static MeetingServiceObjectManager s_obj;
            return s_obj;
        }

        ~MeetingServiceObjectManager()
        {
            
        }

        void reset()
        {
            m_pMMController = NULL;
            m_pDSController = NULL;
            m_pMAController = NULL;
            m_pCMRMgr = NULL;
            m_pProvider = NULL;
        }
        
        //unifyfactory
        //
        void setJabberServiceProvider(JabberServiceProvider * pProvider) { m_pProvider = pProvider; }
		void setJabberServiceSink(JabberServiceSink * pSink) { m_pSink = pSink; }
        void setMeetingMgrController(MeetingMgrControllerImpl * pController) { m_pMMController = pController; }
        void setDesktopSharingController(DesktopSharingControllerImpl * pController) { m_pDSController = pController; }
        void setMeetingAccountController(MeetingAccountControllerImpl * pController) { m_pMAController = pController; }
        void setCMRMgr(CMRControllerMgr * pMgr) { m_pCMRMgr = pMgr; }

        JabberServiceProvider * getJabberServiceProvider() { return m_pProvider; }
		JabberServiceSink * getJabberServiceSink() { return m_pSink; }
        MeetingMgrControllerImpl * getMeetingMgrController() { return m_pMMController; }
        DesktopSharingControllerImpl * getDesktopSharingController() { return m_pDSController; }
        MeetingAccountControllerImpl * getMeetingAccountController() { return m_pMAController; }
        CMRControllerMgr * getCMRMgr() { return m_pCMRMgr; }
        
    private:
        MeetingServiceObjectManager()
        {
            reset();
        }
        
    private:
        MeetingMgrControllerImpl * m_pMMController;
        DesktopSharingControllerImpl * m_pDSController;
        MeetingAccountControllerImpl * m_pMAController;
        CMRControllerMgr * m_pCMRMgr;
        JabberServiceProvider * m_pProvider;
		JabberServiceSink * m_pSink;
    };
};


#endif	// __meeting_service_object_manager_h__